/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.library;

import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;
import org.orecruncher.sndctrl.api.effects.IEntityEffectFactoryHandler;
import org.orecruncher.sndctrl.config.Config;

@OnlyIn(value=Dist.CLIENT)
public final class EntityEffectLibrary {
    private static final ObjectArray<IEntityEffectFactoryHandler> entityEffectfactoryHandlers = new ObjectArray();

    private EntityEffectLibrary() {
    }

    public static void initialize() {
    }

    public static void complete() {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            SoundControl.LOGGER.info("Registered Handlers", new Object[0]);
            SoundControl.LOGGER.info("===================", new Object[0]);
            for (IEntityEffectFactoryHandler h : entityEffectfactoryHandlers) {
                SoundControl.LOGGER.info(h.getName().toString(), new Object[0]);
            }
        }
    }

    @Nonnull
    public static ObjectArray<AbstractEntityEffect> getEffects(@Nonnull LivingEntity entity) {
        ObjectArray<AbstractEntityEffect> result = new ObjectArray<AbstractEntityEffect>();
        entityEffectfactoryHandlers.forEach(h -> {
            if (h.appliesTo(entity)) {
                result.add(h.get(entity));
            }
        });
        result.trim();
        return result;
    }

    public static void register(@Nonnull IEntityEffectFactoryHandler handler) {
        entityEffectfactoryHandlers.add(handler);
    }
}

